require( "scripts/style.lua" );

HudFont = {
	edwardian_medium,
	14,
	BlackColor
};

ChocolateHud = {
	
	Bitmap {
		image = "ui/backgrounds/shop_hud",
		x= kMax - 226,y=0,
		
		Button{
			x = 32,
			y = 11,
            sound = "audio/sfx/buttonclick.ogg",
			graphics = { "ui/buttons/hud_menu","ui/buttons/hud_menu","ui/buttons/hud_menu_over" },
			Text{
				x = 0,
				y = 0,
				w = kMax,
				h = kMax,
				font = {edwardian_medium, 14, BlackColor},
				flags = kHAlignCenter + kVAlignCenter,
				label = "btn_menu",
			},
			Bitmap{
				x = 0,
				y = 0,
				image = "ui/button/hud_menu_overlay",
			},
			command = 
				function()
					DoModal( "scripts/pause.lua" );
				end
		},
		
		BLayeredWindow {
			name = "progress_gauge",
			x = 0, y = 0,
			w = kMax, h = kMax,
		
			SelectLayer(0),
			Bitmap {
				name = "progress_goal",
				x = 78, y = 37, w = 55, h = 42,
				image = "ui/gauges/hud_goal",
				
				Text {
					x = 7, y = 0, w = 48, h = 16,
					flags = kHAlignCenter + kVAlignCenter,
					font = HudFont,
					label = "hud_goal",
				},
			},
			
			RShrinkText {
				name = "goal_score",
				x = 88, y = 76, w = 40, h = 18,
				flags = kHAlignCenter + kVAlignCenter,
				font = {
					edwardian_medium,
					16,
					Color(21,59,79),
				},
				label = "#400",
			},
			
			SelectLayer(1),
			Bitmap {
				name = "progress_master",
				x = 78, y = 37, w = 55, h = 42,
				image = "ui/gauges/hud_master",
				
				Text {
					x = 7, y = 0, w = 48, h = 16,
					flags = kHAlignCenter + kVAlignCenter,
					font = HudFont,
					label = "hud_master",
				},
			},
			
			RShrinkText {
				name = "mastery_score",
				x = 90, y = 76, w = 36, h = 18,
				flags = kHAlignCenter + kVAlignCenter,
				font = {
					edwardian_medium,
					16,
					Color(134,41,47),
				},
				label = "#700",
			},
			
			SelectLayer(2),
			Bitmap {
				name = "progress_anger",
				x = 78, y = 37, w = 55, h = 42,
				image = "ui/gauges/hud_master",
				
				Text {
					x = 7, y = 0, w = 48, h = 16,
					flags = kHAlignCenter + kVAlignCenter,
					font = HudFont,
					label = "hud_anger",
				},
			},
			
			Text {
				name = "anger_score",
				x = 90, y = 76, w = 36, h = 18,
				flags = kHAlignCenter + kVAlignCenter,
				font = {
					edwardian_medium,
					16,
					Color(134,41,47),
				},
				label = "#700",
			},
		},
		
		-------------------------------------- Goal
		KDial {			
			name = "dialPower",
			x=0,y=0,w=350,h=350,
			center_x = 108,
			center_y = 75,
			needle = "ui/gauges/needle",
			needle_regx = 3,
			needle_regy = 19,
			needle_scale = 1/6,
			maxrot = 1.5,
			minrot = -1.5,
			startingPos = 0.0,	
			--overlay = "ui/gauges/power_overlay",
			assert = false
		},
		
		-------------------------------------- Timer
		KSweepDial
		{
			x			= 154, 
			y			= 49,
			w			= 62,
			h			= 62,
			name		= "timer_sweep",
			assert		= false,
			sweep		= "ui/gauges/timer_sweep",
			center_x	= 31,
			center_y	= 31,
			overlay		= "ui/gauges/clock_overlay",
		},
		--[[Bitmap{
			x			= 117, 
			y			= 48,
			image = "ui/gauges/clock_overlay",
		},]]--
		Text
		{
			name = "level_name",
			x		= 152,
			y		= 58,
			w		= 62,
			h		= 70,
			flags = kHAlignCenter + kVAlignTop,
			font = {edwardian_medium, 13, BlackColor},
			label = "#Lvl 13",
		},
		RTimer
		{
			x		= 152,
			y		= 77,
			w		= 62,
			h		= 70,
			name	= "game_timer",
			label	= "",
			font	= {edwardian_medium, 22, BlackColor},
			flags	= kVAlignTop + kHAlignCenter,
			hide	= false
		},
			
	--[[	KDial {			
			name = "dialClock",
			x=0,y=0,w=350,h=350,
			centerX = 133,
			centerY = 76,
			needle = "ui/gauges/needle",
			needle_regX = 3,
			needle_regY = 25,
			needle_scale = 1/6,
			maxRot = 0,
			minRot = 6.14,
			startingPos = 0.0,
			overlay = "ui/clcok_overlay",			
		},]]--
		
		-------------------------------------- Scorer
		--[[RScorer
		{
			x			=  75,
			y			=  5,
			w			=  90,
			h			=  25,
			name		= "game_scorer",
			font		= App_MenuButtonFontBig,
			flags		= kVAlignCenter + kHAlignRight,
			hide		= false,
		},]]--
		Text
		{
			x = 85, y = 5,
			w = 125,
			h = 25,
			flags = kHAlignLeft + kVAlignTop,
			font = {edwardian_medium, 23, BlackColor},
			label = "#$",
		},
		VRegister
		{
		    name = "register_window",
		    x =  80,
			y =  5,
			w =  125,
			h =  25,
			numDigits = 7,
			digit = {
			    font = {edwardian_medium, 25, BlackColor},
			    x = 0,
			    y = 0,
			    w = 15,
			    h = 25,
			},
		},
	},
	
	Bitmap {
		name = "extension",
		x = 225,
		y = 122,
		image = "ui/backgrounds/shop_hud_ext",
		
		Button{
			x = 39, y = 20, w = 63, h = 34,
            sound = "audio/sfx/buttonclick.ogg",
			graphics = { "ui/buttons/hud_upgrade","ui/buttons/hud_upgrade","ui/buttons/hud_upgrade_over" },
			Text{
				x = 0,
				y = 0,
				w = kMax,
				h = kMax,
				font = {edwardian_medium, 14, BlackColor},
				flags = kHAlignCenter + kVAlignCenter,
				label = "btn_upgrade",
			},
			command = 
				function()
					DoModal( "scripts/prelevel.lua" );
				end
		}
	}
}